function slider_graph(rate_uit,rate_vkt,new_rate_uit,new_rate_vkt, new_rate2, new_rate3, num_trials, time_t,l_array,t_total,W_jil,one_stim,all_stim,old_rate_uit,old_rate_vkt,W_jil_initial,T,delta,dt,plot_rate_vt1,Q_ijl,t_stim)
    l = l_array(1);
    f = figure('rend','painters','pos',[300 100 1200 700]);
    p = uipanel('Parent',f,'BorderType','none'); 
  %   p.Title = sprintf('Network Dynamics during learning (Trial %d)',l);
    p.Title = 'Network Dynamics Before Learning';
    p.TitlePosition = 'centertop'; 
    p.FontSize = 12;
    p.FontWeight = 'bold';
    subplot(4,1,1,'Parent',p)
    set(0,'DefaultAxesColorOrder',brewermap(10,'Paired'));
    h = plot(time_t,old_rate_uit(1,:,l),...
        time_t,old_rate_uit(2,:,l),...
        time_t,old_rate_uit(3,:,l),...
        time_t,old_rate_uit(4,:,l),...
        time_t,old_rate_uit(5,:,l),...
        time_t,old_rate_uit(6,:,l),...
        time_t,old_rate_uit(7,:,l),...
        time_t,old_rate_uit(8,:,l),...
        time_t,old_rate_uit(9,:,l),...
        time_t,old_rate_uit(10,:,l),...
        time_t,old_rate_uit(11,:,l),...
        time_t,old_rate_uit(12,:,l),...
        time_t,old_rate_uit(4,:,l), 'r--',...
        time_t,old_rate_uit(4,:,l), 'b--'); 
    xticks(t_stim-1);
    axis([0 t_total 0.01 15]);
    title('Excitatory');
    xlabel('Time(ms)'); 
    ylabel('Firing Rates');
    subplot(4,1,2,'Parent',p)
    m = imagesc(plot_rate_vt1(:,:,l));
    title('Sparse pattern');
    xlabel('Time(ms)'); 
    ylabel('Neuron number');
    subplot(4,1,3,'Parent',p)
    k = imagesc(Q_ijl(:,:,l));
    title('Weight Matrix Q_{ij}');
    xlabel('Postsynaptic Unit'); 
    ylabel('Presynaptic Unit');
    
%%
    r_p = uipanel('Parent',p,'Title','Learning Stage','FontSize',12,...
                  'Position',[0 0 .5 .25]);
    s_p = uipanel('Parent',p,'Title','Trial Number','FontSize',12,...
                  'Position',[.5 0 .5 .25], 'HandleVisibility', 'off');
           
    bg = uibuttongroup('Parent',r_p,'Position',[.2 .2 1 1],...
                    'SelectionChangedFcn',@bselection,...
                    'BorderType','none');

              
% Create three radio buttons in the button group.
    r1 = uicontrol(bg,'Style','radiobutton',...
                    'String','Before Learning',...
                    'Position',[120 90 100 40]);
              
    r2 = uicontrol(bg,'Style','radiobutton',...
                    'String','During Learning',...
                    'Position',[120 60 100 40]);

    r3 = uicontrol(bg,'Style','radiobutton',...
                    'String','After Learning ',...
                    'Position',[120 30 100 40]);
    slid = uicontrol('Parent', s_p, 'Style', 'slider','Min', 1, 'Max', numel(l_array), ...
                    'Value', 1, 'Position', [50 50 480 30],'SliderStep',[1/numel(l_array) 1/numel(l_array)], ...
                    'Callback', @react_to_slider, 'Visible', 'off');
    tex = uicontrol('Parent', s_p, 'Style', 'text', ...
                    'String', sprintf('Trial Number %d',l),...
                    'Position', [225 80 150 30],...
                    'FontSize', 18, 'Visible', 'off');            
%%            
    function bselection(bg,event)
        selection = get(event.NewValue, 'String');
        if selection == 'Before Learning'
           set(p,'Title','Network Dynamics Before Learning');
           s_p.HandleVisibility = 'off';
           slid.Visible = 'off';
           tex.Visible = 'off';
           NameArray = {'XData','YData'};
           ValueArray = {time_t, old_rate_uit(1,:);...
           time_t, old_rate_uit(2,:);...
           time_t, old_rate_uit(3,:);...
           time_t, old_rate_uit(4,:);...
           time_t, old_rate_uit(5,:);...
           time_t, old_rate_uit(6,:);...
           time_t, old_rate_uit(7,:);...
           time_t, old_rate_uit(8,:);...
           time_t, old_rate_uit(9,:);...
           time_t, old_rate_uit(10,:);...
           time_t, old_rate_uit(11,:);...
           time_t, old_rate_uit(12,:);...
           time_t, old_rate_uit(4,:,1);...
           time_t, old_rate_uit(4,:,1)};
           set(h, NameArray,ValueArray);
           set(m, 'CData',plot_rate_vt1(:,:,1));
           set(k,'CData',Q_ijl(:,:,1));
        elseif selection == 'During Learning'
           s_p.HandleVisibility = 'on';
           slid.Visible = 'on';
           tex.Visible = 'on';
           NameArray = {'XData','YData'};
           ValueArray = {time_t, new_rate_uit(1,:,l);...
           time_t, new_rate_uit(2,:,l);...
           time_t, new_rate_uit(3,:,l);...
           time_t, new_rate_uit(4,:,l);...
           time_t, new_rate_uit(5,:,l);...
           time_t, new_rate_uit(6,:,l);...
           time_t, new_rate_uit(7,:,l);...
           time_t, new_rate_uit(8,:,l);...
           time_t, new_rate_uit(9,:,l);...
           time_t, new_rate_uit(10,:,l);...
           time_t, new_rate_uit(11,:,l);...
           time_t, new_rate_uit(12,:,l);...
           time_t, new_rate2(:,l);...
           time_t, new_rate3(:,l)};
           set(h, NameArray,ValueArray);
           set(m, 'CData',plot_rate_vt1(:,:,l));
           set(k,'CData',Q_ijl(:,:,l));
           set(p,'Title',sprintf('Network Dynamics during learning (Trial %d)',l));
           @react_to_slider;
        else
           set(p,'Title',sprintf('Network Dynamics After Learning for %d Trials', num_trials));
           s_p.HandleVisibility = 'off';
           slid.Visible = 'off';
           tex.Visible = 'off';
           NameArray = {'XData','YData'};
           ValueArray = {time_t, rate_uit(1,:);...
           time_t, rate_uit(2,:);...
           time_t, rate_uit(3,:);...
           time_t, rate_uit(4,:);...
           time_t, rate_uit(5,:);...
           time_t, rate_uit(6,:);...
           time_t, rate_uit(7,:);...
           time_t, rate_uit(8,:);...
           time_t, rate_uit(9,:);...
           time_t, rate_uit(10,:);...
           time_t, rate_uit(11,:);...
           time_t, rate_uit(12,:);...
           time_t, old_rate_uit(4,:,1);...
           time_t, old_rate_uit(4,:,1)};
           set(h, NameArray,ValueArray);
           set(m, 'CData',plot_rate_vt1(:,:,num_trials));
           set(k,'CData',Q_ijl(:,:,num_trials));
           
       end
    end



%%
    function react_to_slider(source, event2)   %nested !!
        val = get(source, 'Value');
        l = l_array(round(val));
        set(source, 'Value', val);
        set(p,'Title',sprintf('Network Dynamics during learning (Trial %d)',l));
        NameArray = {'XData','YData'};
        ValueArray = {time_t, new_rate_uit(1,:,l);...
           time_t, new_rate_uit(2,:,l);...
           time_t, new_rate_uit(3,:,l);...
           time_t, new_rate_uit(4,:,l);...
           time_t, new_rate_uit(5,:,l);...
           time_t, new_rate_uit(6,:,l);...
           time_t, new_rate_uit(7,:,l);...
           time_t, new_rate_uit(8,:,l);...
           time_t, new_rate_uit(9,:,l);...
           time_t, new_rate_uit(10,:,l);...
           time_t, new_rate_uit(11,:,l);...
           time_t, new_rate_uit(12,:,l);...
           time_t, new_rate2(:,l);...
           time_t, new_rate3(:,l)};
        set(h, NameArray,ValueArray);
        set(m,'CData',plot_rate_vt1(:,:,l));
        set(k,'CData',Q_ijl(:,:,l));
        set(tex,'String',sprintf('Trial Number %d',l));
    end
%%
end